#!/usr/bin/env python
# Remove assignments
# Copyright 2004, 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070317 - first version of this script based on Remove dependencies

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def DoRemoveAssignments(self):
        if debug: print " Start Remove Assignments"

        # find the selected rows
        sel = self.Report.GetSelectedRows()  # current selection
        if len(sel) < 1:
            hint("Must select at least one task.")
            return

        # is this a task report
        r = Data.Report[self.ReportID]
        if not r.has_key('ReportTypeID') or not Data.ReportType.has_key(r['ReportTypeID']): 
            if debug: print "ReportType key not found"
            return
        rt = Data.ReportType[r['ReportTypeID']]
        ta = rt.get('TableA')
        # tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
        if ta != 'Task':
            hint("Use only on Task reports.")
            return  # only on task reports

        rows = self.Report.table.rows
        tids = [ Data.ReportRow[rows[x]].get('TableID') for x in sel if Data.ReportRow[rows[x]].get('TableName') == 'Task' ]
        if len(tids) < 1:
            hint("Must select at least one task.")
            return

        dba = Data.Database['Assignment']
        aids = [ x for x in dba if dba[x].get('TaskID') in tids ]

        for aid in aids:  # delete existing dependency records
            # look for an existing dependency record
            if Data.Database['Assignment'][aid].get('zzStatus') != 'deleted':
                change = { 'Table': 'Assignment', 'ID': aid, 'zzStatus': 'deleted' }
                Data.Update(change)
        Data.SetUndo("Remove Assignments")

        if debug: print "End Remove Assignments"

DoRemoveAssignments(self)
